<?php
session_start();
include('connection.php'); // Include the database connection

// Fetch positions from the database
$query = "SELECT * FROM school_positions ORDER BY id ASC";
$result = mysqli_query($con, $query);

// Handle delete request
if (isset($_GET['delete_id'])) {
    $delete_id = mysqli_real_escape_string($con, $_GET['delete_id']);
    $delete_query = "DELETE FROM school_positions WHERE id = '$delete_id'";
    if (mysqli_query($con, $delete_query)) {
        header('Location: admin_view_positions.php?success=Position deleted successfully');
    } else {
        header('Location: admin_view_positions.php?error=Failed to delete position');
    }
}

// Handle update request (edit)
if (isset($_POST['update_position'])) {
    $update_id = mysqli_real_escape_string($con, $_POST['position_id']);
    $new_position_name = mysqli_real_escape_string($con, $_POST['position_name']);
    
    $update_query = "UPDATE school_positions SET position_name = '$new_position_name' WHERE id = '$update_id'";
    if (mysqli_query($con, $update_query)) {
        header('Location: admin_view_positions.php?success=Position updated successfully');
    } else {
        header('Location: admin_view_positions.php?error=Failed to update position');
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Positions</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-12 text-center mb-4">
            <h1 class="display-4 text-primary font-weight-bold">School Positions</h1>
            <p class="lead text-muted">Manage all the positions in your school with ease.</p>
        </div>
    </div>
</div>

        
        <!-- Button to trigger the modal -->
        <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#addPositionModal">
            Add New Position
        </button>

        <!-- Table to display positions -->
        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead class="table-dark">
                    <tr>
                        <th>ID</th>
                        <th>Position Name</th>
                        <th>Created At</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if (mysqli_num_rows($result) > 0) {
                        while ($row = mysqli_fetch_assoc($result)) {
                            echo "<tr>
                                    <td>{$row['id']}</td>
                                    <td>{$row['position_name']}</td>
                                    <td>{$row['created_at']}</td>
                                    <td>
                                        <!-- Edit Button -->
                                        <button class='btn btn-warning' data-bs-toggle='modal' data-bs-target='#editPositionModal' data-id='{$row['id']}' data-position_name='{$row['position_name']}'>Edit</button>
                                        
                                        <!-- Delete Button -->
                                        <a href='?delete_id={$row['id']}' class='btn btn-danger' onclick='return confirm(\"Are you sure you want to delete this position?\")'>Delete</a>
                                    </td>
                                  </tr>";
                        }
                    } else {
                        echo "<tr><td colspan='4' class='text-center'>No positions found</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal to add a new position -->
    <div class="modal fade" id="addPositionModal" tabindex="-1" aria-labelledby="addPositionModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addPositionModalLabel">Add New Position</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="add_position.php" method="POST">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="position_name" class="form-label">Position Name</label>
                            <input type="text" class="form-control" id="position_name" name="position_name" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Add Position</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal to edit a position -->
    <div class="modal fade" id="editPositionModal" tabindex="-1" aria-labelledby="editPositionModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editPositionModalLabel">Edit Position</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="admin_view_positions.php" method="POST">
                    <div class="modal-body">
                        <div class="mb-3">
                            <input type="hidden" id="position_id" name="position_id">
                            <label for="edit_position_name" class="form-label">Position Name</label>
                            <input type="text" class="form-control" id="edit_position_name" name="position_name" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary" name="update_position">Update Position</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        // JavaScript to populate the edit modal with current position data
        var editPositionModal = document.getElementById('editPositionModal');
        editPositionModal.addEventListener('show.bs.modal', function (event) {
            var button = event.relatedTarget; // Button that triggered the modal
            var positionId = button.getAttribute('data-id');
            var positionName = button.getAttribute('data-position_name');

            var modalIdInput = editPositionModal.querySelector('#position_id');
            var modalPositionNameInput = editPositionModal.querySelector('#edit_position_name');

            modalIdInput.value = positionId;
            modalPositionNameInput.value = positionName;
        });
    </script>
</body>
</html>

